<?php
/**
 * Admin AJAX handlers for InstantPay – Solana Payments for WordPress.
 *
 * @package InstantPay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class InstantPay_Admin_Ajax {

	/**
	 * Handle connection updates coming from the embedded dashboard (via postMessage + AJAX).
	 *
	 * @return void
	 */
	public function handle_update_connection() {
		// Capability kontrolü
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( array( 'message' => 'Unauthorized' ), 403 );
		}

		// CSRF koruması: Nonce doğrulama
		if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'instantpay_update_connection' ) ) {
			wp_send_json_error( array( 'message' => 'Invalid security token' ), 403 );
		}

		$username_raw = isset( $_POST['username'] ) ? sanitize_text_field( wp_unslash( $_POST['username'] ) ) : '';
		$site_url  = isset( $_POST['site_url'] ) ? esc_url_raw( wp_unslash( $_POST['site_url'] ) ) : '';
		$site_token = isset( $_POST['site_token'] ) ? sanitize_text_field( wp_unslash( $_POST['site_token'] ) ) : '';

		$options = get_option( 'instantpay_options', array() );

		// Eğer username '__CLEAR__' ise, bağlantıyı tamamen temizle (null yap)
		// Aksi halde username'i güncelle (boş string olsa bile - yeni cüzdan bağlı ama username henüz seçilmemiş)
		if ( $username_raw === '__CLEAR__' ) {
			unset( $options['username'] );
		} else {
			$options['username'] = $username_raw;
		}
		
		// Token'ı güncelle
		$options['site_token'] = $site_token;

		// İleride gerekirse site_url'i de ayrı bir option'da saklayabiliriz.
		update_option( 'instantpay_options', $options );

		wp_send_json_success(
			array(
				'username'  => isset( $options['username'] ) ? $options['username'] : '',
				'site_url'  => $site_url,
				'site_token'=> $site_token,
			)
		);
	}
}


