<?php
/**
 * Gutenberg blocks for InstantPay – Solana Payments for WordPress.
 *
 * v0: Minimal registration, acts as wrappers around shortcodes.
 *
 * @package InstantPay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class InstantPay_Blocks {

	/**
	 * Register Gutenberg blocks.
	 *
	 * @return void
	 */
	public function register_blocks() {
		if ( ! function_exists( 'register_block_type' ) ) {
			return;
		}

		// Donate block.
		register_block_type(
			'instantpay/donate',
			array(
				'render_callback' => array( $this, 'render_donate_block' ),
				'attributes'      => array(
					'username' => array(
						'type'    => 'string',
						'default' => '',
					),
					'amount'   => array(
						'type'    => 'string',
						'default' => '',
					),
					'theme'    => array(
						'type'    => 'string',
						'default' => 'light',
					),
				),
				'supports'        => array(
					'align' => true,
				),
			)
		);

		// Product block.
		register_block_type(
			'instantpay/product',
			array(
				'render_callback' => array( $this, 'render_product_block' ),
				'attributes'      => array(
					'id'       => array(
						'type'    => 'string',
						'default' => '',
					),
					'username' => array(
						'type'    => 'string',
						'default' => '',
					),
					'theme'    => array(
						'type'    => 'string',
						'default' => 'light',
					),
				),
				'supports'        => array(
					'align' => true,
				),
			)
		);

		// Page block.
		register_block_type(
			'instantpay/page',
			array(
				'render_callback' => array( $this, 'render_page_block' ),
				'attributes'      => array(
					'username' => array(
						'type'    => 'string',
						'default' => '',
					),
				),
				'supports'        => array(
					'align' => true,
				),
			)
		);
	}

	/**
	 * Donate block render – delegates to shortcode.
	 *
	 * @param array $attributes Block attributes.
	 * @return string
	 */
	public function render_donate_block( $attributes ) {
		$atts = array();

		if ( ! empty( $attributes['username'] ) ) {
			$atts['username'] = $attributes['username'];
		}
		if ( ! empty( $attributes['amount'] ) ) {
			$atts['amount'] = $attributes['amount'];
		}
		if ( ! empty( $attributes['theme'] ) ) {
			$atts['theme'] = $attributes['theme'];
		}

		return do_shortcode( $this->build_shortcode( 'instantpay_donate', $atts ) );
	}

	/**
	 * Product block render – delegates to shortcode.
	 *
	 * @param array $attributes Block attributes.
	 * @return string
	 */
	public function render_product_block( $attributes ) {
		$atts = array();

		if ( ! empty( $attributes['id'] ) ) {
			$atts['id'] = $attributes['id'];
		}
		if ( ! empty( $attributes['username'] ) ) {
			$atts['username'] = $attributes['username'];
		}
		if ( ! empty( $attributes['theme'] ) ) {
			$atts['theme'] = $attributes['theme'];
		}

		return do_shortcode( $this->build_shortcode( 'instantpay_product', $atts ) );
	}

	/**
	 * Page block render – delegates to shortcode.
	 *
	 * @param array $attributes Block attributes.
	 * @return string
	 */
	public function render_page_block( $attributes ) {
		$atts = array();

		if ( ! empty( $attributes['username'] ) ) {
			$atts['username'] = $attributes['username'];
		}

		return do_shortcode( $this->build_shortcode( 'instantpay_page', $atts ) );
	}

	/**
	 * Helper to build shortcode string from attributes.
	 *
	 * @param string $tag  Shortcode tag.
	 * @param array  $atts Attributes.
	 * @return string
	 */
	private function build_shortcode( $tag, $atts ) {
		$parts = array();

		foreach ( $atts as $key => $value ) {
			if ( $value === '' ) {
				continue;
			}
			$parts[] = sprintf(
				'%s="%s"',
				$key,
				esc_attr( $value )
			);
		}

		$attr_string = implode( ' ', $parts );

		if ( $attr_string ) {
			return sprintf( '[%s %s]', $tag, $attr_string );
		}

		return sprintf( '[%s]', $tag );
	}
}


