<?php
/**
 * Plugin Name:       InstantPay – Solana Payments
 * Description:       Accept Solana (SOL) donations and digital product payments using your InstantPay account, directly from WordPress.
 * Version:           1.0.0
 * Author:            InstantPay
 * Author URI:        https://instantpay.now
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       instantpay-solana-payments
 * Requires at least: 5.8
 * Requires PHP:      7.4
 *
 * @package InstantPay
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! defined( 'INSTANTPAY_PLUGIN_VERSION' ) ) {
	define( 'INSTANTPAY_PLUGIN_VERSION', '1.0.0' );
}

if ( ! defined( 'INSTANTPAY_PLUGIN_FILE' ) ) {
	define( 'INSTANTPAY_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'INSTANTPAY_PLUGIN_DIR' ) ) {
	define( 'INSTANTPAY_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'INSTANTPAY_PLUGIN_URL' ) ) {
	define( 'INSTANTPAY_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

// Autoload core classes.
require_once INSTANTPAY_PLUGIN_DIR . 'includes/class-instantpay-plugin.php';

/**
 * Main plugin bootstrap.
 */
function instantpay_run_plugin() {
	$plugin = new InstantPay_Plugin();
	$plugin->run();
}

// Initialize plugin.
add_action( 'plugins_loaded', 'instantpay_run_plugin' );

/**
 * Activation hook.
 */
function instantpay_activate() {
	// Placeholder: add initial options or setup here if needed.
	if ( ! get_option( 'instantpay_options' ) ) {
		add_option(
			'instantpay_options',
			array(
				'username'          => '',
				'site_token'        => '',
				'auto_append_script'=> 1,
			)
		);
	}
}
register_activation_hook( __FILE__, 'instantpay_activate' );

/**
 * Deactivation hook.
 */
function instantpay_deactivate() {
	// Placeholder for future cleanup logic (cron jobs, caches, etc.).
}
register_deactivation_hook( __FILE__, 'instantpay_deactivate' );


